﻿//////////////////////////////////////////////
// ResourceManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class ResourceSaveLoadCallback ;
	class ResourceSetLoadQuery ;
	class ResourceSetLoadResult ;
	class ResourceSetSaveQuery ;
	class System ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT ResourceManager : public nkCommon::MaybeSingletonClass<ResourceManager>
	{		
		public :

			// Global loading
			void loadResourceSetDescFileSync (const ResourceSetLoadQuery& query, ResourceSetLoadResult& resultRef) ;
			void loadResourceSetDescFileAsync (const ResourceSetLoadQuery& query, ResourceSaveLoadCallback* callback = nullptr) ;
			// Sauvegarde
			void saveResourceSetDescFile (const ResourceSetSaveQuery& query) ;

			// Isolated loading requests
			// Cameras
			void loadCamera (nkMemory::StringView path, ResourceSaveLoadCallback* callback = nullptr) ;
			// States
			void loadBlendState (nkMemory::StringView path, ResourceSaveLoadCallback* callback = nullptr) ;
			void loadDepthStencilState (nkMemory::StringView path, ResourceSaveLoadCallback* callback = nullptr) ;
			void loadRasterState (nkMemory::StringView path, ResourceSaveLoadCallback* callback = nullptr) ;
			// Textures
			void loadSampler (nkMemory::StringView path, ResourceSaveLoadCallback* callback = nullptr) ;
			void loadTexture (nkMemory::StringView path, ResourceSaveLoadCallback* callback = nullptr) ;
			// Buffer
			void loadBuffer (nkMemory::StringView path, ResourceSaveLoadCallback* callback = nullptr) ;
			// Shaders
			void loadShader (nkMemory::StringView path, ResourceSaveLoadCallback* callback = nullptr) ;
			void loadProgram (nkMemory::StringView path, ResourceSaveLoadCallback* callback = nullptr) ;
			// Mesh
			void loadMesh (nkMemory::StringView path, ResourceSaveLoadCallback* callback = nullptr) ;
			// Compositor
			void loadCompositor (nkMemory::StringView path, nkMemory::StringView compoToDefault = "", ResourceSaveLoadCallback* callback = nullptr) ;
			// Node
			void loadNode (nkMemory::StringView path, ResourceSaveLoadCallback* callback = nullptr) ;

		private :

			// Constructor
			ResourceManager (bool isSingleton) noexcept ;
			ResourceManager (System* system) noexcept ;

		private :

			// Attributes
			System* _system ;

		private :

			friend class nkCommon::MaybeSingletonClass<ResourceManager> ;
			friend class System ;
	} ;
}